(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    139354,       3938]
NotebookOptionsPosition[    122703,       3686]
NotebookOutlinePosition[    123128,       3703]
CellTagsIndexPosition[    123085,       3700]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilGebra`"}]], "Input",
 CellChangeTimes->{{3.972568017635283*^9, 3.972568021651699*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"35a9f1bb-c8e2-426f-8422-e8be79c42689"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilGebra cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
03/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.972568022159453*^9, 3.972579911275172*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"674df29c-1433-4222-9ec3-173eb57c1016"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Proyecci\[OAcute]n ortogonal: calcular la proyecci\[OAcute]n de v sobre el \
subespacio W. \
\>", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.9724756263011913`*^9}, {3.972578040073368*^9, 3.972578042256878*^9}, {
  3.9725798704678593`*^9, 
  3.972579875110359*^9}},ExpressionUUID->"ede8184d-b578-4fd4-8ab3-\
a6b8cee3f5cb"],

Cell["1. Sea v = (3, 1, 4) y W = Gen{ (1,1,0), (1,0,1) } en \:211d^3.", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972577990571616*^9}, 
   3.97257988247486*^9},ExpressionUUID->"0725a142-533f-484d-a553-\
2601b558e495"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9725799050582037`*^9, 3.972579923759087*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"0942f5d7-d160-474e-9041-857f055feeb4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "3"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["10", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.972579925419724*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"f9d79699-794d-49ef-872f-1aed525ea2e7"]
}, Open  ]],

Cell["\<\
2. Sea v = (2, 3, 1, 2) y W = Gen{ (1,0,1,0), (0,1,0,1) } en \:211d^4.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578000905985*^9}, 
   3.97257996348254*^9},ExpressionUUID->"605eea48-8667-4607-9b65-\
53e7c021ceb7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9725799691165333`*^9, 3.972579972730359*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"d3eed9eb-67ba-496b-9be1-04b7460ffd70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.972579973649417*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"62bd65f0-188d-4b76-ba6b-b2d965b826d0"]
}, Open  ]],

Cell["3. Sea v = (5, -1, 2) y W = Gen{ (1,2,1) } en \:211d^3.", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578002884411*^9}, 
   3.972580034346093*^9},ExpressionUUID->"7272d9e1-6e41-4114-93ec-\
11c1fb7b60ac"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", "w", "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9725800436091623`*^9, 3.972580050443967*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"dd08942b-bbc9-449f-9728-723560357044"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "6"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["5", "6"]}], "}"}]], "Output",
 CellChangeTimes->{3.972580050838273*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"7f924901-aa0f-4536-9587-74e28065dc81"]
}, Open  ]],

Cell["\<\
4. Sea v = (1, 2, -1, 3, 0) y W = Gen{ (1,0,1,0,0), (0,1,1,1,0) } en \:211d^5.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578004745612*^9}, 
   3.97258016610994*^9},ExpressionUUID->"b9c7ec59-ceb3-4c82-99c8-\
34a8e2967d13"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "3", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{3.972580185550828*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"5ec6b93b-9462-482f-ac22-44a71ae9a8fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["4", "5"]}], ",", 
   FractionBox["8", "5"], ",", 
   FractionBox["4", "5"], ",", 
   FractionBox["8", "5"], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.972580186552684*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"904caf0e-aba8-4096-aaf8-d3e481a8dd91"]
}, Open  ]],

Cell["\<\
5. Sea v = (4, -2, 1, 3) y W = Gen{ (2,1,0,0), (1,1,1,0), (0,1,1,1) } en \
\:211d^4.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578006461245*^9}, 
   3.972580281032449*^9},ExpressionUUID->"0aa9d649-eb2b-4814-b822-\
fc3afe92baaf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "2"}], ",", "1", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9725802969338617`*^9, 3.972580299599474*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"2e2010ec-1c00-42af-86e2-d68c9600b50a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["16", "7"], ",", 
   FractionBox["10", "7"], ",", 
   RowBox[{"-", 
    FractionBox["5", "7"]}], ",", 
   FractionBox["9", "7"]}], "}"}]], "Output",
 CellChangeTimes->{3.972580300494533*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"86cf17a1-1830-4186-a888-aa21e23275d8"]
}, Open  ]],

Cell["\<\
6. Sea v = (3,0,2,1) y W = Gen{ (1,1,1,1), (1,-1,0,0) } en \:211d^4.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578008458725*^9}, 
   3.972580420831567*^9},ExpressionUUID->"b34d2f7e-8527-486a-be69-\
7a0210538143"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.972580435216938*^9, 3.972580435219284*^9}, {
  3.972580499330208*^9, 3.9725805054804983`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"e4bd4095-1507-4aee-bc81-7acbc39b36c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.9725805059729137`*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"7d94302a-251d-4a73-b63a-6f67e7f6f24a"]
}, Open  ]],

Cell["\<\
7. Sea v = (1,1,1,1,1) y W = Gen{ (1,0,0,1,0), (0,1,0,0,1) } en \:211d^5.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578011044757*^9}, 
   3.9725807392154512`*^9},ExpressionUUID->"c34d504d-0c65-44a0-8504-\
b28949637861"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9725807579380283`*^9, 3.972580763532279*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"ec4c3984-bd94-40cd-91ed-d47d917860ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.9725807642842703`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"b15bffdb-9301-4961-9e84-a610c58db3fe"]
}, Open  ]],

Cell["\<\
8. Sea v = (2, -1, 3, 0, 4, 1) y W = Gen{ (1,1,0,0,0,0), (0,0,1,1,0,0), \
(0,0,0,0,1,1) } en \:211d^6.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578012792128*^9}, {3.972580855865839*^9, 
   3.972580860735156*^9}},ExpressionUUID->"963ad033-3d85-47ce-993d-\
5531ff00a230"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3", ",", "0", ",", "4", ",", "1"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"g1", ",", "g2", ",", "g3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.972580876373065*^9, 3.97258088308852*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"265f3636-ecf2-4721-abca-254a34ffc287"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["5", "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.972580883928308*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"9e724d24-7ea1-4488-b068-bf2b9a602bef"]
}, Open  ]],

Cell["\<\
9. Sea v = (1, -2, 0, 3, -1, 2) y W el subespacio de R^6 definido por las \
ecuaciones: x1 + x2 = 0 y x3 + x4 = 0.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578014589786*^9}, 3.972580928646716*^9, {3.972581132002346*^9, 
   3.9725811391118317`*^9}},ExpressionUUID->"b07e09b0-cfef-4e69-a666-\
f2dcd30a8333"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "0", ",", "3", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"e2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"e4", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"PrOt", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"e1", ",", "e2", ",", "e3", ",", "e4"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9725809809341173`*^9, 3.9725809903255033`*^9}, {
  3.9725811455618343`*^9, 3.9725811644175377`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"40867ec6-2d42-448e-95fe-628a07e2a005"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   RowBox[{"-", 
    FractionBox["3", "2"]}], ",", 
   RowBox[{"-", 
    FractionBox["3", "2"]}], ",", 
   FractionBox["3", "2"], ",", 
   RowBox[{"-", "1"}], ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.972581166988117*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"7b0e16d7-ac3f-44c3-bd76-a7a4813a679f"]
}, Open  ]],

Cell["\<\
10. Sea v = (2, 1, 3, -1, 0, 2, 1) y W el subespacio de R^7 definido por las \
ecuaciones: x1 + x2 = 0  y  x3 + x4 + x5 = 0.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578016417186*^9}, {3.972581339202531*^9, 
   3.97258134454082*^9}},ExpressionUUID->"e491cf2e-0b1b-4baf-bd52-\
61f6f5183330"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e1", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], "   "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"e2", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", 
      RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], ";"}], "   "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"e3", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
      RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"e4", "=", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], 
     "}"}]}], ";"}], "    "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"e5", "=", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], 
     "}"}]}], ";"}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PrOt", "[", 
   RowBox[{"v", ",", 
    RowBox[{"{", 
     RowBox[{"e1", ",", "e2", ",", "e3", ",", "e4", ",", "e5"}], "}"}]}], 
   "]"}], "  "}]}], "Input",
 CellChangeTimes->{{3.9725813621017847`*^9, 3.9725813880575733`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"ae9cbf82-910b-487d-ba35-ad790ed47743"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["7", "3"], ",", 
   RowBox[{"-", 
    FractionBox["5", "3"]}], ",", 
   RowBox[{"-", 
    FractionBox["2", "3"]}], ",", "2", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972581388465682*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"88086324-9c1d-4c1e-a3c7-1c0d1706d137"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conjuntos ortogonales u ortonormales", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.9724756263011913`*^9}, {3.9725780546697702`*^9, 
  3.972578060189698*^9}},ExpressionUUID->"b601b8f2-40c2-4473-9c56-\
220cb6510a81"],

Cell["1. { (1/\[Sqrt]2)(1,1,0), (1/\[Sqrt]2)(1,-1,0), (0,0,1) }", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972577990571616*^9}, 
   3.9725817918511047`*^9},ExpressionUUID->"9e2c4fe4-c3f8-4c91-8e26-\
d7916d85bfe7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.9725818070436487`*^9, 3.97258180704709*^9}, {
  3.972581878787921*^9, 3.972581899541465*^9}, {3.97258201668709*^9, 
  3.972582017135882*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"05aaa612-6ec8-4b90-bd14-fce3b72d7e68"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.972581809676506*^9, {3.9725818877455177`*^9, 3.972581900367024*^9}, 
   3.9725820177099*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"e830c9e0-1ab0-4961-adec-f5a6d5d24ce5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.972581809676506*^9, {3.9725818877455177`*^9, 3.972581900367024*^9}, 
   3.972582017710462*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"5321943a-4882-43d8-b1c2-baf7a89aa4ec"]
}, Open  ]],

Cell["2. {(2,1,0), (1,-2,0), (0,0,3)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578000905985*^9}, 
   3.9725820762067347`*^9},ExpressionUUID->"9ed84959-2a75-453e-aca3-\
3f2629269cdd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{3.972582090475711*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"ae8bf419-aa56-478c-ba27-53061d1a271a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582093368024*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"920ea283-74cd-4394-a3b3-0382e37452aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["5"], ",", 
   SqrtBox["5"], ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.972582093369429*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"d4817325-5444-45bc-a68a-435b9cbe6548"]
}, Open  ]],

Cell["3. {(1,2,1), (1,0,-1), (2,-1,0)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578002884411*^9}, 
   3.972582147918371*^9},ExpressionUUID->"45919b9e-67fb-4a2f-a314-\
6d7534bca067"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.972582153761014*^9, 3.97258215979294*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"fad47dcf-13d8-4365-af4a-7077948c11d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582160728421*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"9ed14b96-6569-48c6-8778-ed8e8990122c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["6"], ",", 
   SqrtBox["2"], ",", 
   SqrtBox["5"]}], "}"}]], "Output",
 CellChangeTimes->{3.972582160729781*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"4054b92b-f37e-471e-b7f7-50fb1ecdf120"]
}, Open  ]],

Cell["4. {(1/\[Sqrt]3)(1,1,1), (1/\[Sqrt]2)(1,-1,0), (1/\[Sqrt]6)(1,1,-2)}", \
"Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578004745612*^9}, 
   3.972582365104443*^9},ExpressionUUID->"c56ff1db-9736-4f9a-8fdf-\
883e5b8b54be"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "6", "]"}]}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.972582267839995*^9, 3.972582268515321*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"940f2e01-1a83-4eeb-955b-d7226d2a0064"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582269699554*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"244794e5-8716-49cf-a01d-5f6abeb3bd76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972582269701064*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"ae113a91-dd4f-464d-8665-b22ca8f1c7d6"]
}, Open  ]],

Cell["5. {(1,0,1,0), (0,1,0,1), (1,0,-1,0), (0,1,0,-1)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578006461245*^9}, 
   3.972582416728999*^9},ExpressionUUID->"22e8525b-f657-4294-a6bc-\
8cbf0536fdc0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u4", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4"}], "}"}]}], "}"}]}], 
   "]"}], "//", "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.972582427431498*^9, 3.9725824369714527`*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"d564456f-ed6f-4ca4-b4d1-ef9adda304c1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582437988167*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"8deeb3c0-dc96-47df-9c48-08014fa8bc70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["2"], ",", 
   SqrtBox["2"], ",", 
   SqrtBox["2"]}], "}"}]], "Output",
 CellChangeTimes->{3.972582437989562*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"55dd51c7-d831-442f-b55f-26e963ac3040"]
}, Open  ]],

Cell["6. {1, Cos[x], Sin[x]}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578008458725*^9}, 
   3.9725825448880987`*^9},ExpressionUUID->"5d8afc73-8637-4cec-a632-\
720d2c3906b3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"Cos", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f3", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"p", "*", "q"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"dot11", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f1", ",", "f1"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot12", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f1", ",", "f2"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot13", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f1", ",", "f3"}], "]"}], "//", "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"dot21", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f2", ",", "f1"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot22", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f2", ",", "f2"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot23", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f2", ",", "f3"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot31", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f3", ",", "f1"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot32", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f3", ",", "f2"}], "]"}], "//", "Simplify"}]}], "\n", 
 RowBox[{"dot33", "=", 
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"f3", ",", "f3"}], "]"}], "//", "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"Gram", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dot11", ",", "dot12", ",", "dot13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dot21", ",", "dot22", ",", "dot23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dot31", ",", "dot32", ",", "dot33"}], "}"}]}], "}"}], "//", 
   "Simplify"}]}], "\n", 
 RowBox[{"NormsSq", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dot11", ",", "dot22", ",", "dot33"}], "}"}], "//", 
   "Simplify"}]}], "\n", 
 RowBox[{"isOrthogonal", "=", 
  RowBox[{"And", "@@", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "==", "j"}], ",", "True", ",", 
        RowBox[{
         RowBox[{"Gram", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "==", "0"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]}]}], "\n", 
 RowBox[{"isOrthonormal", "=", 
  RowBox[{"And", "@@", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Gram", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "==", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "==", "j"}], ",", "1", ",", "0"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]}]}], "\n", 
 RowBox[{"{", 
  RowBox[{"Gram", ",", "NormsSq", ",", "isOrthogonal", ",", "isOrthonormal"}],
   "}"}]}], "Input",
 CellChangeTimes->{{3.972582552189788*^9, 3.972582612446184*^9}, {
  3.972582819680892*^9, 3.972582826155591*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"d1e6a428-da96-4585-a083-9552dc2c837c"],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830119728*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"504f824c-d86e-412e-954e-850c7b4429a8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.9725828301204243`*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"65c04787-933a-4248-bb20-73e16d564e3a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830120957*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"c321a93d-3b83-4a69-a443-3d5bda64c23e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830121469*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"4d2e54bb-f858-411d-a144-ff23a3de1a4c"],

Cell[BoxData["\[Pi]"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830121972*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"8dc7474d-4408-4327-b233-1c741e3534b2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830122465*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"3aaf2ccf-667e-4bcc-8fa2-ec3a2ce936e8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.9725828301229677`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"fdb656cc-8f93-4944-9cf7-299f59398b10"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.9725828301234694`*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"0494a28f-20d4-4f27-8055-397e04623559"],

Cell[BoxData["\[Pi]"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830138465*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"1e7ed709-27ee-47dc-a682-3a605d99261d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "\[Pi]"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "\[Pi]", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "\[Pi]"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.9725828301393423`*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"de8b9e99-28d3-4862-b228-9d094aa0a8dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "\[Pi]"}], ",", "\[Pi]", ",", "\[Pi]"}], "}"}]], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.9725828301398478`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"8aaf9f3c-cf9a-474d-85bb-84af76cd6695"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830140307*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"4ffcfd3a-5a89-4234-a6c2-16cdcff52d47"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830140749*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"3f197d82-a965-451a-8406-28c57f2aa67d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", " ", "\[Pi]"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Pi]", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "\[Pi]"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "\[Pi]"}], ",", "\[Pi]", ",", "\[Pi]"}], "}"}], ",", 
   "True", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.97258261339744*^9, 3.972582830141223*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"8f590905-dad3-44d6-b8e0-92f0029f62fc"]
}, Open  ]],

Cell["\<\
7. {(1/2)(1,1,1,1), (1/2)(1,1,-1,-1), (1/2)(1,-1,1,-1), (1/2)(1,-1,-1,1)}\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578011044757*^9}, 
   3.972582665577416*^9},ExpressionUUID->"ea8e65eb-1abc-4125-bae2-\
176b4e141bf0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u4", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3", ",", "u4"}], "}"}]}], "}"}]}], 
   "]"}], "//", "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.972582678703175*^9, 3.9725826855545588`*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"1a473c0a-fcbd-43ef-8209-2fa2bad4f503"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582685959202*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"18fce5b9-7418-465e-826f-3764aeae0b82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972582685960286*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"758966df-705e-451f-8c04-87520118fb35"]
}, Open  ]],

Cell["\<\
8. { {{1,0},{0,0}}, {{0,1},{0,0}}, {{0,0},{1,0}}, {{0,0},{0,1}} } \
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578012792128*^9}, 
   3.972582745325383*^9},ExpressionUUID->"c48a5fa7-39c9-4ce8-be58-\
9b7e5420705a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"E11", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"E12", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"E21", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"E22", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mats", "=", 
   RowBox[{"{", 
    RowBox[{"E11", ",", "E12", ",", "E21", ",", "E22"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inner", "[", 
   RowBox[{"A_", ",", "B_"}], "]"}], ":=", 
  RowBox[{"Tr", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", "A", "]"}], ".", "B"}], "]"}]}], "\n", 
 RowBox[{"Gram", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"inner", "[", 
      RowBox[{
       RowBox[{"mats", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"mats", "[", 
        RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "mats", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "[", "mats", "]"}]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"NormsSq", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"inner", "[", 
      RowBox[{
       RowBox[{"mats", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"mats", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "mats", "]"}]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"isOrthogonal", "=", 
  RowBox[{"And", "@@", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "==", "j"}], ",", "True", ",", 
        RowBox[{
         RowBox[{"Gram", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "==", "0"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "mats", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "mats", "]"}]}], "}"}]}], "]"}], "]"}]}]}], "\n", 
 RowBox[{"isOrthonormal", "=", 
  RowBox[{"And", "@@", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Gram", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "==", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "==", "j"}], ",", "1", ",", "0"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "mats", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "mats", "]"}]}], "}"}]}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"Gram", ",", "NormsSq", ",", "isOrthogonal", ",", "isOrthonormal"}],
   "}"}]}], "Input",
 CellChangeTimes->{{3.9725827565547028`*^9, 3.972582800627572*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"a01db5ab-03cb-498b-8a0d-f12f60e54a0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582801639215*^9, 3.9725828364762573`*^9},
 CellLabel->
  "Out[176]=",ExpressionUUID->"edce3866-18cb-4c04-98ce-c2b541540f72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972582801639215*^9, 3.9725828364770517`*^9},
 CellLabel->
  "Out[177]=",ExpressionUUID->"e1dfa4e8-0a92-4299-a10d-239952681441"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.972582801639215*^9, 3.972582836477693*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"5f8e2aea-d246-42e6-bbd9-7ecf7628f594"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.972582801639215*^9, 3.9725828364782553`*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"7c213327-10c5-4b49-9622-5f0b45ae0503"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "True", ",", 
   "True"}], "}"}]], "Output",
 CellChangeTimes->{3.972582801639215*^9, 3.972582836478854*^9},
 CellLabel->
  "Out[180]=",ExpressionUUID->"0dc52129-b999-4b55-ae97-8e8e4566d32d"]
}, Open  ]],

Cell["9. {(1,2,-1,0,1), (2,-1,0,1,-2), (0,1,2,-1,0)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578014589786*^9}, 
   3.972582891312207*^9},ExpressionUUID->"34c6f572-531f-4498-858c-\
08dd8ea28b4d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ui", ".", "uj"}], ",", 
    RowBox[{"{", 
     RowBox[{"ui", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"uj", ",", 
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2", ",", "u3"}], "}"}]}], "}"}]}], "]"}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{"Norms", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], ",", 
     RowBox[{"Norm", "[", "u2", "]"}], ",", 
     RowBox[{"Norm", "[", "u3", "]"}]}], "}"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.9725828999007177`*^9, 3.9725829005847683`*^9}},
 CellLabel->
  "In[181]:=",ExpressionUUID->"dea78014-94eb-4576-9018-37285c064e89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "10", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "2"}], ",", "6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972582904468713*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"0dbde4f0-c17c-4feb-b048-a5ffa1239000"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["7"], ",", 
   SqrtBox["10"], ",", 
   SqrtBox["6"]}], "}"}]], "Output",
 CellChangeTimes->{3.972582904470296*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"fa3b8d01-8424-43c4-9e37-97aa05835436"]
}, Open  ]],

Cell["\<\
10. { 1/Sqrt[2\[Pi]], (cos x)/Sqrt[\[Pi]], (sin x)/Sqrt[\[Pi]], (cos \
2x)/Sqrt[\[Pi]], (sin 2x)/Sqrt[\[Pi]] }\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578016417186*^9}, 
   3.972582936630274*^9},ExpressionUUID->"db453ef0-9f00-4b6e-9f4a-\
687fbdf6cb9a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", " ", "Pi"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "/", 
    RowBox[{"Sqrt", "[", "Pi", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f3", "=", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"Sqrt", "[", "Pi", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f4", "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "Pi", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f5", "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", "Pi", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"funcs", "=", 
   RowBox[{"{", 
    RowBox[{"f1", ",", "f2", ",", "f3", ",", "f4", ",", "f5"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"p", "*", "q"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Gram", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"inner", "[", 
      RowBox[{
       RowBox[{"funcs", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"funcs", "[", 
        RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "funcs", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "[", "funcs", "]"}]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"isOrthonormal", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Gram", "==", 
     RowBox[{"IdentityMatrix", "[", 
      RowBox[{"Length", "[", "funcs", "]"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NormsSq", "=", 
   RowBox[{"Diagonal", "[", "Gram", "]"}]}], ";"}], "\n", 
 RowBox[{"CrossDots", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gram", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "funcs", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "[", "funcs", "]"}]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"Gram", ",", "NormsSq", ",", "isOrthonormal"}], "}"}]}], "Input",
 CellChangeTimes->{{3.972582950801777*^9, 3.972582984619692*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"863dbfce-2e46-4c29-904e-a73eb6f09e69"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.972582985956175*^9},
 CellLabel->
  "Out[193]=",ExpressionUUID->"6285004d-b47c-44e5-9691-e273d907527f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.972582985957487*^9},
 CellLabel->
  "Out[196]=",ExpressionUUID->"92ee805b-efde-4b9f-94e5-866a43848c7f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   "True"}], "}"}]], "Output",
 CellChangeTimes->{3.972582985957864*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"cb0a6aa3-7a47-4f5d-a2ba-b7dffffcc487"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gram-Schmidt", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
   3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
   3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
   3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
   3.9724756263011913`*^9}, 
   3.9725780833503513`*^9},ExpressionUUID->"220dd669-50c8-4cb8-9089-\
7ec1424c60f1"],

Cell["1. {(1,2,1), (2,1,0), (1,0,1)} ", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972577990571616*^9}, 
   3.9725831235192623`*^9},ExpressionUUID->"6aa46707-f6a8-4fc5-9f76-\
2654afaf0058"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.97258312615252*^9, 3.972583145096739*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"f16c455d-9674-4872-aea8-6cbe10b70c4f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     SqrtBox[
      FractionBox["2", "3"]], ",", 
     FractionBox["1", 
      SqrtBox["6"]]}], "}"}]}],
  SequenceForm[
  "Vector 1 de la base ortonormal: ", {
   6^Rational[-1, 2], Rational[2, 3]^Rational[1, 2], 6^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.97258314602941*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"5bd9b9d8-64ba-4f51-bfdd-40d1bb0481c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", 
      SqrtBox["21"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["21"]]}], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["21"]]}]}], "}"}]}],
  SequenceForm[
  "Vector ", 2, " de la base ortonormal: ", {
   4 21^Rational[-1, 2], -21^Rational[-1, 2], (-2) 21^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583146030517*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"89ac2701-ceb1-47b7-a3bb-14b20a390bcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["2", "3"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"-", 
      FractionBox["2", "3"]}]}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[2, 3], 
    Rational[4, 3], 
    Rational[2, 3]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[4, 3], 
    Rational[-1, 3], 
    Rational[-2, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725831460311747`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"71e7015a-ba62-4a2c-91c0-c2eee12d082a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["14"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "7"]]}], ",", 
     FractionBox["3", 
      SqrtBox["14"]]}], "}"}]}],
  SequenceForm[
  "Vector ", 3, " de la base ortonormal: ", {
   14^Rational[-1, 2], -Rational[2, 7]^Rational[1, 2], 3 14^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583146033556*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"b79b2d38-17cc-4647-af2c-ff03cc46f577"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "7"], ",", 
     FractionBox["4", "7"], ",", 
     FractionBox["1", "7"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "7"], ",", 
     RowBox[{"-", 
      FractionBox["4", "7"]}], ",", 
     FractionBox["6", "7"]}], "}"}]}],
  SequenceForm[
  "Con i=", 3, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[5, 7], 
    Rational[4, 7], 
    Rational[1, 7]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[2, 7], 
    Rational[-4, 7], 
    Rational[6, 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.97258314603402*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"1e5a4af7-6a80-45db-9200-aee7049ac9b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     SqrtBox[
      FractionBox["2", "3"]], ",", 
     FractionBox["1", 
      SqrtBox["6"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", 
      SqrtBox["21"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["21"]]}], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["21"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["14"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "7"]]}], ",", 
     FractionBox["3", 
      SqrtBox["14"]]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.9725831460346527`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[198]:=",ExpressionUUID->"60150383-fcf9-46ea-aa4a-d6b24fa940c4"]
}, Open  ]]
}, Open  ]],

Cell["2. {(1,1,0), (1,0,1)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578000905985*^9}, 
   3.972583524301557*^9},ExpressionUUID->"6ceb1243-7101-4a46-89e0-\
02725a11bb39"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.97258353766775*^9, 3.972583543228127*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"97491c83-82e0-48ba-b102-3b02da99777b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "0"}], "}"}]}],
  SequenceForm[
  "Vector 1 de la base ortonormal: ", {
   2^Rational[-1, 2], 2^Rational[-1, 2], 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583544000585*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[202]:=",ExpressionUUID->"2d56075a-0acb-454d-b005-d748ac99b898"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["6"]]}], ",", 
     SqrtBox[
      FractionBox["2", "3"]]}], "}"}]}],
  SequenceForm[
  "Vector ", 2, " de la base ortonormal: ", {
   6^Rational[-1, 2], -6^Rational[-1, 2], Rational[2, 3]^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725835440012703`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[202]:=",ExpressionUUID->"cbb7b5ca-4464-490d-8ea0-82a3609453e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", "1"}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[1, 2], 0}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[-1, 2], 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583544002016*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[202]:=",ExpressionUUID->"1b521f80-7493-4ee9-ad70-941a246a5aad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["6"]]}], ",", 
     SqrtBox[
      FractionBox["2", "3"]]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.9725835440026913`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[202]:=",ExpressionUUID->"cff186ac-8a1f-4ca4-ac36-40373cfb5759"]
}, Open  ]]
}, Open  ]],

Cell["3. {(1,1,1,1), (1,1,0,0), (1,0,0,0)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578002884411*^9}, 
   3.9725836314850616`*^9},ExpressionUUID->"8d412afa-a071-4621-a1e9-\
88b25cc38cae"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.972583637237378*^9, 3.972583647316112*^9}},
 CellLabel->
  "In[205]:=",ExpressionUUID->"77b7e4b9-d66b-4cc8-9907-3b7dccd4942f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}]}],
  SequenceForm["Vector 1 de la base ortonormal: ", {
    Rational[1, 2], 
    Rational[1, 2], 
    Rational[1, 2], 
    Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725836483951283`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[205]:=",ExpressionUUID->"08d8d3d9-8b67-4fef-be7f-d8591959ddf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}],
  SequenceForm["Vector ", 2, " de la base ortonormal: ", {
    Rational[1, 2], 
    Rational[1, 2], 
    Rational[-1, 2], 
    Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583648396221*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[205]:=",ExpressionUUID->"bd0171df-2c4e-413a-b1a9-571ddfac9664"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[1, 2], 
    Rational[1, 2], 
    Rational[1, 2]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[1, 2], 
    Rational[-1, 2], 
    Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583648397434*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[205]:=",ExpressionUUID->"d7fc979a-0e65-4b06-b962-e4d51c602f28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", "0", ",", "0"}], "}"}]}],
  SequenceForm[
  "Vector ", 3, " de la base ortonormal: ", {
   2^Rational[-1, 2], -2^Rational[-1, 2], 0, 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583648398539*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[205]:=",ExpressionUUID->"6892ce6b-62fa-4b04-b1e0-0d8776ef3f16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", "0", ",", "0"}], "}"}]}],
  SequenceForm[
  "Con i=", 3, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[1, 2], 0, 0}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[-1, 2], 0, 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583648399172*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[205]:=",ExpressionUUID->"fc6deb98-3fb5-4a74-b70d-64170365207e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", "0", ",", "0"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.972583648400025*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[205]:=",ExpressionUUID->"06070c23-25a4-4131-a9a8-b2c10e853857"]
}, Open  ]]
}, Open  ]],

Cell["4. {(2,0,1), (1,1,0), (0,1,1)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578004745612*^9}, 
   3.972583801394786*^9},ExpressionUUID->"21cb7d66-6f72-4fa8-8efc-\
4c8479dc3853"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{3.972583815168627*^9},
 CellLabel->
  "In[209]:=",ExpressionUUID->"5dcc8e9e-a00a-4ced-b248-59905b5b623c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", 
      SqrtBox["5"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["5"]]}], "}"}]}],
  SequenceForm[
  "Vector 1 de la base ortonormal: ", {
   2 5^Rational[-1, 2], 0, 5^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583816354063*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[209]:=",ExpressionUUID->"86eb1fc3-b33f-4648-b769-8ca166e74deb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["30"]], ",", 
     SqrtBox[
      FractionBox["5", "6"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "15"]]}]}], "}"}]}],
  SequenceForm[
  "Vector ", 2, " de la base ortonormal: ", {
   30^Rational[-1, 2], Rational[5, 6]^Rational[1, 2], -
    Rational[2, 15]^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583816354632*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[209]:=",ExpressionUUID->"166af5d2-9c59-47fc-9b3a-51fd5224e3f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "5"], ",", "0", ",", 
     FractionBox["2", "5"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "5"], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox["2", "5"]}]}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[4, 5], 0, 
    Rational[2, 5]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 5], 1, 
    Rational[-2, 5]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583816355081*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[209]:=",ExpressionUUID->"aaf6f6a2-af1f-4f2d-9b4a-2aadc4d6b412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["6"]]}], ",", 
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     SqrtBox[
      FractionBox["2", "3"]]}], "}"}]}],
  SequenceForm[
  "Vector ", 3, 
   " de la base ortonormal: ", {-6^Rational[-1, 2], 6^Rational[-1, 2], 
    Rational[2, 3]^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725838163557673`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[209]:=",ExpressionUUID->"0379325c-e38e-4d92-92ae-705efdfb8cbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "2"], ",", "1"}], "}"}]}],
  SequenceForm[
  "Con i=", 3, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[1, 2], 0}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[-1, 2], 
    Rational[1, 2], 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972583816356229*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[209]:=",ExpressionUUID->"303006d1-b031-41b0-8053-17081f5dfacf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", 
      SqrtBox["5"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["5"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["30"]], ",", 
     SqrtBox[
      FractionBox["5", "6"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "15"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["6"]]}], ",", 
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     SqrtBox[
      FractionBox["2", "3"]]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.97258381635684*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[209]:=",ExpressionUUID->"0b393304-efe8-4796-91bc-98216edf13f2"]
}, Open  ]]
}, Open  ]],

Cell["5. {(1,0,1,0,1), (0,1,0,1,0), (1,1,0,0,0)}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578006461245*^9}, {3.972583995655869*^9, 
   3.972584006302541*^9}},ExpressionUUID->"dc42a622-db81-41dc-84ee-\
b045f9eae8ea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{3.972584021868705*^9},
 CellLabel->
  "In[213]:=",ExpressionUUID->"253acdbd-1d01-4e2b-9e11-d4e5d5f84c0b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["3"]]}], "}"}]}],
  SequenceForm[
  "Vector 1 de la base ortonormal: ", {
   3^Rational[-1, 2], 0, 3^Rational[-1, 2], 0, 3^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972584023211816*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[213]:=",ExpressionUUID->"7c29ebc7-4271-49e8-a10a-080f7dbce5e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "0"}], "}"}]}],
  SequenceForm[
  "Vector ", 2, " de la base ortonormal: ", {
   0, 2^Rational[-1, 2], 0, 2^Rational[-1, 2], 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972584023212933*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[213]:=",ExpressionUUID->"efeafbd6-be8e-4beb-ba27-b044bc188fe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {0, 0, 0, 0, 0}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {0, 1, 
   0, 1, 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972584023214013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[213]:=",ExpressionUUID->"a531b6ab-3533-4663-8e3c-39d9a7297aac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "21"]]}], ",", 
     SqrtBox[
      FractionBox["3", "14"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "21"]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["3", "14"]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "21"]]}]}], "}"}]}],
  SequenceForm[
  "Vector ", 3, " de la base ortonormal: ", {
   2 Rational[2, 21]^Rational[1, 2], Rational[3, 14]^Rational[1, 2], -
    Rational[2, 21]^Rational[1, 2], -Rational[3, 14]^Rational[1, 2], -
    Rational[2, 21]^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972584023214991*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[213]:=",ExpressionUUID->"4d8f60e7-e8d1-4d55-bc7c-e826094dbcfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}]}], "}"}]}],
  SequenceForm[
  "Con i=", 3, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 3], 
    Rational[1, 2], 
    Rational[1, 3], 
    Rational[1, 2], 
    Rational[1, 3]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[2, 3], 
    Rational[1, 2], 
    Rational[-1, 3], 
    Rational[-1, 2], 
    Rational[-1, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725840232156878`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[213]:=",ExpressionUUID->"b6dcc78c-8c24-4a44-ab74-38b13666dcd7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "21"]]}], ",", 
     SqrtBox[
      FractionBox["3", "14"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "21"]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["3", "14"]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "21"]]}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.972584023216627*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[213]:=",ExpressionUUID->"28b13147-077b-478a-b8fb-5f24def6af0b"]
}, Open  ]]
}, Open  ]],

Cell["6. {1, x, x^2}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578008458725*^9}, 
   3.972584105014455*^9},ExpressionUUID->"94355cb7-2d27-478c-9aa3-\
547a5896fc6f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"basis", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"p", "*", "q"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"basis", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"basis", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"inner", "[", 
         RowBox[{
          RowBox[{"basis", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "u1"}], "]"}], "/", 
        RowBox[{"inner", "[", 
         RowBox[{"u1", ",", "u1"}], "]"}]}], ")"}], " ", "u1"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"u3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"basis", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"inner", "[", 
         RowBox[{
          RowBox[{"basis", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", "u1"}], "]"}], "/", 
        RowBox[{"inner", "[", 
         RowBox[{"u1", ",", "u1"}], "]"}]}], ")"}], " ", "u1"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"inner", "[", 
         RowBox[{
          RowBox[{"basis", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", "u2"}], "]"}], "/", 
        RowBox[{"inner", "[", 
         RowBox[{"u2", ",", "u2"}], "]"}]}], ")"}], " ", "u2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"u1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"inner", "[", 
       RowBox[{"u1", ",", "u1"}], "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"u2", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"inner", "[", 
       RowBox[{"u2", ",", "u2"}], "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"u3", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"inner", "[", 
       RowBox[{"u3", ",", "u3"}], "]"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"e1", ",", "e2", ",", "e3"}], "}"}]}], "Input",
 CellChangeTimes->{{3.972584113469227*^9, 3.9725841404959373`*^9}, 
   3.972584283852528*^9},ExpressionUUID->"9ed2d6df-c03a-42d0-97cf-\
06b64c3fb437"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], ")"}]}], ",", 
   RowBox[{
    SqrtBox["5"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"6", " ", "x"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.9725841415738697`*^9},
 CellLabel->
  "Out[226]=",ExpressionUUID->"16061a6f-2673-45b2-a45b-c001ab0ac16a"]
}, Open  ]],

Cell["7. ", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578011044757*^9}},ExpressionUUID->"caea9d9b-0e8f-4fef-94b1-\
e26b1973cc95"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.972584273917388*^9, 3.972584287168932*^9}},
 CellLabel->
  "In[227]:=",ExpressionUUID->"8983308a-cfa9-483d-8ef7-b43bf6efcfea"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     SqrtBox[
      FractionBox["2", "3"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["6"]]}], "}"}]}],
  SequenceForm[
  "Vector 1 de la base ortonormal: ", {
   6^Rational[-1, 2], Rational[2, 3]^Rational[1, 2], 0, 6^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972584288236472*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[227]:=",ExpressionUUID->"116639c3-6a9d-454c-ac24-45c9051a4ebb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "15"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["30"]]}], ",", 
     SqrtBox[
      FractionBox["3", "10"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "15"]]}]}], "}"}]}],
  SequenceForm[
  "Vector ", 2, " de la base ortonormal: ", {
   2 Rational[2, 15]^Rational[1, 2], -30^Rational[-1, 2], Rational[3, 10]^
    Rational[1, 2], -Rational[2, 15]^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725842882376127`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[227]:=",ExpressionUUID->"791f8961-9948-4a04-9c35-6db8b15e970f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", 
     FractionBox["4", "3"], ",", "0", ",", 
     FractionBox["2", "3"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", "1", ",", 
     RowBox[{"-", 
      FractionBox["2", "3"]}]}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[2, 3], 
    Rational[4, 3], 0, 
    Rational[2, 3]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[4, 3], 
    Rational[-1, 3], 1, 
    Rational[-2, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725842882385674`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[227]:=",ExpressionUUID->"fe4b40ea-54a3-4056-91cb-37366b375a9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["5"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["5"]}]]}], ",", 
     FractionBox["3", 
      RowBox[{"2", " ", 
       SqrtBox["5"]}]], ",", 
     FractionBox["3", 
      RowBox[{"2", " ", 
       SqrtBox["5"]}]]}], "}"}]}],
  SequenceForm[
  "Vector ", 3, " de la base ortonormal: ", {
   Rational[-1, 2] 5^Rational[-1, 2], Rational[-1, 2] 5^Rational[-1, 2], 
    Rational[3, 2] 5^Rational[-1, 2], Rational[3, 2] 5^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725842882395067`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[227]:=",ExpressionUUID->"d52284a1-efea-4166-a96b-c2b68cb55fb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "5"], ",", 
     FractionBox["7", "5"], ",", 
     RowBox[{"-", 
      FractionBox["1", "5"]}], ",", 
     FractionBox["4", "5"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "5"]}], ",", 
     RowBox[{"-", 
      FractionBox["2", "5"]}], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["6", "5"]}], "}"}]}],
  SequenceForm[
  "Con i=", 3, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[2, 5], 
    Rational[7, 5], 
    Rational[-1, 5], 
    Rational[4, 5]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[-2, 5], 
    Rational[-2, 5], 
    Rational[6, 5], 
    Rational[6, 5]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972584288240108*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[227]:=",ExpressionUUID->"812840bc-b797-45f4-bacd-67934be3d0d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     SqrtBox[
      FractionBox["2", "3"]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["6"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "15"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["30"]]}], ",", 
     SqrtBox[
      FractionBox["3", "10"]], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "15"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["5"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["5"]}]]}], ",", 
     FractionBox["3", 
      RowBox[{"2", " ", 
       SqrtBox["5"]}]], ",", 
     FractionBox["3", 
      RowBox[{"2", " ", 
       SqrtBox["5"]}]]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.972584288240958*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[227]:=",ExpressionUUID->"2b631537-2e0e-4452-a708-a47b567a926f"]
}, Open  ]]
}, Open  ]],

Cell["\<\
8. A1 = {{1, 0}, {0, 1}}
    A2 = {{1, 1}, {0, 0}}
    A3 = {{0, 1}, {1, 0}}\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578012792128*^9}, {3.972584467629115*^9, 
   3.972584473721374*^9}},ExpressionUUID->"f42bb7d0-693c-422a-974b-\
f985cedd5fd0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"A1", ",", "A2", ",", "A3"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"inner", "[", 
    RowBox[{"A_", ",", "B_"}], "]"}], ":=", 
   RowBox[{"Tr", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "A", "]"}], ".", "B"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u1", "=", "A1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e1", "=", 
   RowBox[{
    RowBox[{"u1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"inner", "[", 
       RowBox[{"u1", ",", "u1"}], "]"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u2", "=", 
   RowBox[{
    RowBox[{"A2", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"inner", "[", 
         RowBox[{"A2", ",", "u1"}], "]"}], "/", 
        RowBox[{"inner", "[", 
         RowBox[{"u1", ",", "u1"}], "]"}]}], ")"}], " ", "u1"}]}], "//", 
    "Simplify"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e2", "=", 
   RowBox[{
    RowBox[{"u2", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"inner", "[", 
       RowBox[{"u2", ",", "u2"}], "]"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"u3", "=", "A3"}], "\n", 
 RowBox[{
  RowBox[{"-", 
   RowBox[{"inner", "[", 
    RowBox[{"A3", ",", "e1"}], "]"}]}], " ", "e1"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inner", "[", 
      RowBox[{"A3", ",", "e2"}], "]"}]}], " ", "e2"}], "//", "Simplify"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"e3", "=", 
   RowBox[{
    RowBox[{"u3", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"inner", "[", 
       RowBox[{"u3", ",", "u3"}], "]"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"e1", ",", "e2", ",", "e3"}], "}"}]}], "Input",
 CellChangeTimes->{{3.972584483164653*^9, 3.972584508601975*^9}, {
   3.972584842023383*^9, 3.972584842430085*^9}, 3.9725853147670507`*^9},
 CellLabel->
  "In[302]:=",ExpressionUUID->"9e8dab9e-48c5-4762-8dcb-5f56a6cf09fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972584509528384*^9, 3.972584684241952*^9, 
  3.9725850536340103`*^9, 3.9725853154539824`*^9},
 CellLabel->
  "Out[311]=",ExpressionUUID->"a558419e-519f-4bc7-9b86-64d4ca930916"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972584509528384*^9, 3.972584684241952*^9, 
  3.9725850536340103`*^9, 3.972585315455161*^9},
 CellLabel->
  "Out[312]=",ExpressionUUID->"aad940f0-07c3-4313-bd5a-5570b5ca1b22"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", 
        SqrtBox["2"]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["6"]], ",", 
       SqrtBox[
        FractionBox["2", "3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["6"]]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", 
        SqrtBox["2"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972584509528384*^9, 3.972584684241952*^9, 
  3.9725850536340103`*^9, 3.972585315455985*^9},
 CellLabel->
  "Out[315]=",ExpressionUUID->"b2267e1b-375b-4be9-a2a4-7295179f489a"]
}, Open  ]],

Cell["9. {{1,1,1,0,0}, {1,0,0,1,1}, {0,1,0,1,0}}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578014589786*^9}, {3.972585453397756*^9, 
   3.972585464363308*^9}},ExpressionUUID->"23390dc2-8f45-4255-bfa3-\
c4d62a0d7329"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MGS", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.972585473169518*^9, 3.972585481508163*^9}},
 CellLabel->
  "In[316]:=",ExpressionUUID->"1a6a5f11-9f22-4e8c-aacc-d9f59f63bf2e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector 1 de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", "0"}], "}"}]}],
  SequenceForm[
  "Vector 1 de la base ortonormal: ", {
   3^Rational[-1, 2], 3^Rational[-1, 2], 3^Rational[-1, 2], 0, 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972585481896543*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[316]:=",ExpressionUUID->"6f40a002-3e7f-4d37-8f50-e009e368c97c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"]}], "}"}]}],
  SequenceForm[
  "Vector ", 2, " de la base ortonormal: ", {
   6^Rational[-1, 2], Rational[-1, 2] 6^Rational[-1, 2], Rational[-1, 2] 
    6^Rational[-1, 2], Rational[1, 2] Rational[3, 2]^Rational[1, 2], 
    Rational[1, 2] Rational[3, 2]^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725854818974113`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[316]:=",ExpressionUUID->"b63a01d2-90f6-437a-b5c9-d39d224db426"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], ",", "1", ",", "1"}], "}"}]}],
  SequenceForm[
  "Con i=", 2, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 3], 
    Rational[1, 3], 
    Rational[1, 3], 0, 0}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[2, 3], 
    Rational[-1, 3], 
    Rational[-1, 3], 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972585481898254*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[316]:=",ExpressionUUID->"40a33a80-d144-4370-a49e-6ba5f50853ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Vector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" de la base ortonormal: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["6"]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}]}],
  SequenceForm[
  "Vector ", 3, 
   " de la base ortonormal: ", {-6^Rational[-1, 2], Rational[1, 2] 
    Rational[3, 2]^Rational[1, 2], Rational[-1, 2] 6^Rational[-1, 2], 
    Rational[1, 2] Rational[3, 2]^Rational[1, 2], Rational[-1, 2] 
    6^Rational[-1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.972585481899047*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[316]:=",ExpressionUUID->"d70f5145-a651-444c-a47d-2c6f2cc80192"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Con i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(Proy\\), \
SubscriptBox[\\(S\\), \\(i - 1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\
\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "4"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" y \\!\\(\\*SubscriptBox[\\(U\\), \
\\(i\\)]\\)-\\!\\(\\*SubscriptBox[\\(Proy\\), SubscriptBox[\\(S\\), \\(i - \
1\\)]]\\)\\!\\(\\*SubscriptBox[\\(U\\), \\(i\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["3", "4"], ",", 
     RowBox[{"-", 
      FractionBox["1", "4"]}], ",", 
     FractionBox["3", "4"], ",", 
     RowBox[{"-", 
      FractionBox["1", "4"]}]}], "}"}]}],
  SequenceForm[
  "Con i=", 3, 
   ", \!\(\*SubscriptBox[\(Proy\), SubscriptBox[\(S\), \(i - \
1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[1, 2], 
    Rational[1, 4], 
    Rational[1, 4], 
    Rational[1, 4], 
    Rational[1, 4]}, 
   " y \!\(\*SubscriptBox[\(U\), \(i\)]\)-\!\(\*SubscriptBox[\(Proy\), \
SubscriptBox[\(S\), \(i - 1\)]]\)\!\(\*SubscriptBox[\(U\), \(i\)]\)=", {
    Rational[-1, 2], 
    Rational[3, 4], 
    Rational[-1, 4], 
    Rational[3, 4], 
    Rational[-1, 4]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.9725854818994627`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[316]:=",ExpressionUUID->"82c378ac-19b1-4278-b783-be4c458abf2c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["6"]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]]}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.9725854818999033`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[316]:=",ExpressionUUID->"ae677ae8-25ff-4076-8baa-997924cc95bb"]
}, Open  ]]
}, Open  ]],

Cell["10. {1, Cos[x], Sin[x]}", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 3.97248058594228*^9, {3.972577988383349*^9, 
   3.972578016417186*^9}, {3.972586095365872*^9, 
   3.9725860979501247`*^9}},ExpressionUUID->"26c5a170-b269-43e8-ba0f-\
876b09f67eee"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], ":=", "1"}], "\n", 
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{"Cos", "[", "x", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f3", "[", "x_", "]"}], ":=", 
  RowBox[{"Sin", "[", "x", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"funcs", "=", 
   RowBox[{"{", 
    RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"inner", "[", 
   RowBox[{"f_", ",", "g_"}], "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], " ", 
     RowBox[{"g", "[", "x", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"GramSchmidtFunc", "[", "fs_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "i", ",", "j"}], "}"}], ",", 
    RowBox[{
     RowBox[{"u", "=", 
      RowBox[{"{", 
       RowBox[{"fs", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "2"}], ",", 
       RowBox[{"i", "<=", 
        RowBox[{"Length", "[", "fs", "]"}]}], ",", 
       RowBox[{"i", "++"}], ",", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"fs", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "-", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"inner", "[", 
                RowBox[{
                 RowBox[{"fs", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "j", "]"}], "]"}]}], "]"}], "/", 
               RowBox[{"inner", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "j", "]"}], "]"}], ",", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ")"}], " ", 
             RowBox[{"u", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", 
              RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}]}]}], "]"}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "k", "]"}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"inner", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "k", "]"}], "]"}], ",", 
            RowBox[{"u", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{"Length", "[", "u", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "u"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ortonormal", "=", 
   RowBox[{"GramSchmidtFunc", "[", "funcs", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ortoEval", "[", "x_", "]"}], ":=", 
  RowBox[{"ortonormal", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "->", 
      RowBox[{"f1", "[", "x", "]"}]}], ",", 
     RowBox[{"f2", "->", 
      RowBox[{"f2", "[", "x", "]"}]}], ",", 
     RowBox[{"f3", "->", 
      RowBox[{"f3", "[", "x", "]"}]}]}], "}"}]}]}], "\n", 
 RowBox[{"ortoEval", "[", "x", "]"}]}], "Input",
 CellChangeTimes->{{3.9725863223660803`*^9, 3.9725863623848333`*^9}, 
   3.9725864000807056`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"e8fdd967-62d7-448a-951e-0f5b96224f07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]], ",", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    SqrtBox["\[Pi]"]], ",", 
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox["\[Pi]"]]}], "}"}]], "Output",
 CellChangeTimes->{3.972586362803816*^9, 3.9725864007906446`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"06dba05c-4ac7-435f-843a-69d0ba99b902"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1357, 640},
WindowMargins->{{Automatic, 26}, {26, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 197, 3, 73, "Input",ExpressionUUID->"35a9f1bb-c8e2-426f-8422-e8be79c42689"],
Cell[780, 27, 1025, 30, 107, "Print",ExpressionUUID->"674df29c-1433-4222-9ec3-173eb57c1016"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1842, 62, 592, 11, 258, "Section",ExpressionUUID->"ede8184d-b578-4fd4-8ab3-a6b8cee3f5cb"],
Cell[2437, 75, 619, 9, 84, "Text",ExpressionUUID->"0725a142-533f-484d-a553-2601b558e495"],
Cell[CellGroupData[{
Cell[3081, 88, 628, 18, 226, "Input",ExpressionUUID->"0942f5d7-d160-474e-9041-857f055feeb4"],
Cell[3712, 108, 271, 7, 104, "Output",ExpressionUUID->"f9d79699-794d-49ef-872f-1aed525ea2e7"]
}, Open  ]],
Cell[3998, 118, 634, 11, 84, "Text",ExpressionUUID->"605eea48-8667-4607-9b65-53e7c021ceb7"],
Cell[CellGroupData[{
Cell[4657, 133, 658, 18, 226, "Input",ExpressionUUID->"d3eed9eb-67ba-496b-9be1-04b7460ffd70"],
Cell[5318, 153, 301, 8, 104, "Output",ExpressionUUID->"62bd65f0-188d-4b76-ba6b-b2d965b826d0"]
}, Open  ]],
Cell[5634, 164, 612, 9, 84, "Text",ExpressionUUID->"7272d9e1-6e41-4114-93ec-11c1fb7b60ac"],
Cell[CellGroupData[{
Cell[6271, 177, 511, 14, 175, "Input",ExpressionUUID->"dd08942b-bbc9-449f-9728-723560357044"],
Cell[6785, 193, 270, 7, 104, "Output",ExpressionUUID->"7f924901-aa0f-4536-9587-74e28065dc81"]
}, Open  ]],
Cell[7070, 203, 642, 11, 84, "Text",ExpressionUUID->"b9c7ec59-ceb3-4c82-99c8-34a8e2967d13"],
Cell[CellGroupData[{
Cell[7737, 218, 684, 19, 226, "Input",ExpressionUUID->"5ec6b93b-9462-482f-ac22-44a71ae9a8fb"],
Cell[8424, 239, 332, 9, 104, "Output",ExpressionUUID->"904caf0e-aba8-4096-aaf8-d3e481a8dd91"]
}, Open  ]],
Cell[8771, 251, 649, 12, 84, "Text",ExpressionUUID->"0aa9d649-eb2b-4814-b822-fc3afe92baaf"],
Cell[CellGroupData[{
Cell[9445, 267, 812, 23, 277, "Input",ExpressionUUID->"2e2010ec-1c00-42af-86e2-d68c9600b50a"],
Cell[10260, 292, 324, 9, 104, "Output",ExpressionUUID->"86cf17a1-1830-4186-a888-aa21e23275d8"]
}, Open  ]],
Cell[10599, 304, 633, 11, 84, "Text",ExpressionUUID->"b34d2f7e-8527-486a-be69-7a0210538143"],
Cell[CellGroupData[{
Cell[11257, 319, 705, 20, 124, "Input",ExpressionUUID->"e4bd4095-1507-4aee-bc81-7acbc39b36c9"],
Cell[11965, 341, 280, 7, 104, "Output",ExpressionUUID->"7d94302a-251d-4a73-b63a-6f67e7f6f24a"]
}, Open  ]],
Cell[12260, 351, 640, 11, 84, "Text",ExpressionUUID->"c34d504d-0c65-44a0-8504-b28949637861"],
Cell[CellGroupData[{
Cell[12925, 366, 672, 18, 226, "Input",ExpressionUUID->"ec4c3984-bd94-40cd-91ed-d47d917860ba"],
Cell[13600, 386, 226, 4, 83, "Output",ExpressionUUID->"b15bffdb-9301-4961-9e84-a610c58db3fe"]
}, Open  ]],
Cell[13841, 393, 691, 12, 139, "Text",ExpressionUUID->"963ad033-3d85-47ce-993d-5531ff00a230"],
Cell[CellGroupData[{
Cell[14557, 409, 884, 27, 277, "Input",ExpressionUUID->"265f3636-ecf2-4721-abca-254a34ffc287"],
Cell[15444, 438, 366, 10, 104, "Output",ExpressionUUID->"9e724d24-7ea1-4488-b068-bf2b9a602bef"]
}, Open  ]],
Cell[15825, 451, 727, 12, 139, "Text",ExpressionUUID->"b07e09b0-cfef-4e69-a666-f2dcd30a8333"],
Cell[CellGroupData[{
Cell[16577, 467, 1154, 34, 328, "Input",ExpressionUUID->"40867ec6-2d42-448e-95fe-628a07e2a005"],
Cell[17734, 503, 381, 11, 104, "Output",ExpressionUUID->"7b0e16d7-ac3f-44c3-bd76-a7a4813a679f"]
}, Open  ]],
Cell[18130, 517, 712, 12, 139, "Text",ExpressionUUID->"e491cf2e-0b1b-4baf-bd52-61f6f5183330"],
Cell[CellGroupData[{
Cell[18867, 533, 1510, 46, 379, "Input",ExpressionUUID->"ae9cbf82-910b-487d-ba35-ad790ed47743"],
Cell[20380, 581, 414, 12, 104, "Output",ExpressionUUID->"88086324-9c1d-4c1e-a3c7-1c0d1706d137"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20843, 599, 480, 7, 165, "Section",ExpressionUUID->"b601b8f2-40c2-4473-9c56-220cb6510a81"],
Cell[21326, 608, 616, 9, 97, "Text",ExpressionUUID->"9e2c4fe4-c3f8-4c91-8e26-d7916d85bfe7"],
Cell[CellGroupData[{
Cell[21967, 621, 1470, 46, 511, "Input",ExpressionUUID->"05aaa612-6ec8-4b90-bd14-fce3b72d7e68"],
Cell[23440, 669, 456, 12, 83, "Output",ExpressionUUID->"e830c9e0-1ab0-4961-adec-f5a6d5d24ce5"],
Cell[23899, 683, 281, 6, 83, "Output",ExpressionUUID->"5321943a-4882-43d8-b1c2-baf7a89aa4ec"]
}, Open  ]],
Cell[24195, 692, 590, 9, 84, "Text",ExpressionUUID->"9ed84959-2a75-453e-aca3-3f2629269cdd"],
Cell[CellGroupData[{
Cell[24810, 705, 1123, 36, 436, "Input",ExpressionUUID->"ae8bf419-aa56-478c-ba27-53061d1a271a"],
Cell[25936, 743, 381, 10, 83, "Output",ExpressionUUID->"920ea283-74cd-4394-a3b3-0382e37452aa"],
Cell[26320, 755, 234, 7, 88, "Output",ExpressionUUID->"d4817325-5444-45bc-a68a-435b9cbe6548"]
}, Open  ]],
Cell[26569, 765, 589, 9, 84, "Text",ExpressionUUID->"45919b9e-67fb-4a2f-a314-6d7534bca067"],
Cell[CellGroupData[{
Cell[27183, 778, 1188, 38, 436, "Input",ExpressionUUID->"fad47dcf-13d8-4365-af4a-7077948c11d0"],
Cell[28374, 818, 385, 11, 83, "Output",ExpressionUUID->"9ed14b96-6569-48c6-8778-ed8e8990122c"],
Cell[28762, 831, 247, 8, 88, "Output",ExpressionUUID->"4054b92b-f37e-471e-b7f7-50fb1ecdf120"]
}, Open  ]],
Cell[29024, 842, 627, 10, 97, "Text",ExpressionUUID->"c56ff1db-9736-4f9a-8fdf-883e5b8b54be"],
Cell[CellGroupData[{
Cell[29676, 856, 1527, 50, 548, "Input",ExpressionUUID->"940f2e01-1a83-4eeb-955b-d7226d2a0064"],
Cell[31206, 908, 385, 11, 83, "Output",ExpressionUUID->"244794e5-8716-49cf-a01d-5f6abeb3bd76"],
Cell[31594, 921, 208, 5, 83, "Output",ExpressionUUID->"ae113a91-dd4f-464d-8665-b22ca8f1c7d6"]
}, Open  ]],
Cell[31817, 929, 606, 9, 84, "Text",ExpressionUUID->"22e8525b-f657-4294-a6bc-8cbf0536fdc0"],
Cell[CellGroupData[{
Cell[32448, 942, 1365, 42, 487, "Input",ExpressionUUID->"d564456f-ed6f-4ca4-b4d1-ef9adda304c1"],
Cell[33816, 986, 494, 13, 83, "Output",ExpressionUUID->"8deeb3c0-dc96-47df-9c48-08014fa8bc70"],
Cell[34313, 1001, 247, 8, 88, "Output",ExpressionUUID->"55dd51c7-d831-442f-b55f-26e963ac3040"]
}, Open  ]],
Cell[34575, 1012, 581, 9, 84, "Text",ExpressionUUID->"5d8afc73-8637-4cec-a632-720d2c3906b3"],
Cell[CellGroupData[{
Cell[35181, 1025, 3586, 109, 1847, "Input",ExpressionUUID->"d1e6a428-da96-4585-a083-9552dc2c837c"],
Cell[38770, 1136, 200, 4, 83, "Output",ExpressionUUID->"504f824c-d86e-412e-954e-850c7b4429a8"],
Cell[38973, 1142, 176, 3, 83, "Output",ExpressionUUID->"65c04787-933a-4248-bb20-73e16d564e3a"],
Cell[39152, 1147, 174, 3, 83, "Output",ExpressionUUID->"c321a93d-3b83-4a69-a443-3d5bda64c23e"],
Cell[39329, 1152, 174, 3, 83, "Output",ExpressionUUID->"4d2e54bb-f858-411d-a144-ff23a3de1a4c"],
Cell[39506, 1157, 178, 3, 83, "Output",ExpressionUUID->"8dc7474d-4408-4327-b233-1c741e3534b2"],
Cell[39687, 1162, 174, 3, 83, "Output",ExpressionUUID->"3aaf2ccf-667e-4bcc-8fa2-ec3a2ce936e8"],
Cell[39864, 1167, 176, 3, 83, "Output",ExpressionUUID->"fdb656cc-8f93-4944-9cf7-299f59398b10"],
Cell[40043, 1172, 176, 3, 83, "Output",ExpressionUUID->"0494a28f-20d4-4f27-8055-397e04623559"],
Cell[40222, 1177, 178, 3, 83, "Output",ExpressionUUID->"1e7ed709-27ee-47dc-a682-3a605d99261d"],
Cell[40403, 1182, 446, 12, 83, "Output",ExpressionUUID->"de8b9e99-28d3-4862-b228-9d094aa0a8dc"],
Cell[40852, 1196, 267, 6, 83, "Output",ExpressionUUID->"8aaf9f3c-cf9a-474d-85bb-84af76cd6695"],
Cell[41122, 1204, 177, 3, 83, "Output",ExpressionUUID->"4ffcfd3a-5a89-4234-a6c2-16cdcff52d47"],
Cell[41302, 1209, 178, 3, 83, "Output",ExpressionUUID->"3f197d82-a965-451a-8406-28c57f2aa67d"],
Cell[41483, 1214, 635, 18, 109, "Output",ExpressionUUID->"8f590905-dad3-44d6-b8e0-92f0029f62fc"]
}, Open  ]],
Cell[42133, 1235, 638, 11, 84, "Text",ExpressionUUID->"ea8e65eb-1abc-4125-bae2-176b4e141bf0"],
Cell[CellGroupData[{
Cell[42796, 1250, 1763, 58, 487, "Input",ExpressionUUID->"1a473c0a-fcbd-43ef-8209-2fa2bad4f503"],
Cell[44562, 1310, 494, 13, 83, "Output",ExpressionUUID->"18fce5b9-7418-465e-826f-3764aeae0b82"],
Cell[45059, 1325, 208, 5, 83, "Output",ExpressionUUID->"758966df-705e-451f-8c04-87520118fb35"]
}, Open  ]],
Cell[45282, 1333, 631, 11, 84, "Text",ExpressionUUID->"c48a5fa7-39c9-4ce8-be58-9b7e5420705a"],
Cell[CellGroupData[{
Cell[45938, 1348, 3649, 115, 1330, "Input",ExpressionUUID->"a01db5ab-03cb-498b-8a0d-f12f60e54a0a"],
Cell[49590, 1465, 518, 13, 83, "Output",ExpressionUUID->"edce3866-18cb-4c04-98ce-c2b541540f72"],
Cell[50111, 1480, 242, 5, 83, "Output",ExpressionUUID->"e1dfa4e8-0a92-4299-a10d-239952681441"],
Cell[50356, 1487, 178, 3, 83, "Output",ExpressionUUID->"5f8e2aea-d246-42e6-bbd9-7ecf7628f594"],
Cell[50537, 1492, 180, 3, 83, "Output",ExpressionUUID->"7c213327-10c5-4b49-9622-5f0b45ae0503"],
Cell[50720, 1497, 680, 18, 134, "Output",ExpressionUUID->"0dc52129-b999-4b55-ae97-8e8e4566d32d"]
}, Open  ]],
Cell[51415, 1518, 603, 9, 84, "Text",ExpressionUUID->"34c6f572-531f-4498-858c-08dd8ea28b4d"],
Cell[CellGroupData[{
Cell[52043, 1531, 1295, 40, 436, "Input",ExpressionUUID->"dea78014-94eb-4576-9018-37285c064e89"],
Cell[53341, 1573, 470, 15, 83, "Output",ExpressionUUID->"0dbde4f0-c17c-4feb-b048-a5ffa1239000"],
Cell[53814, 1590, 248, 8, 88, "Output",ExpressionUUID->"fa3b8d01-8424-43c4-9e37-97aa05835436"]
}, Open  ]],
Cell[54077, 1601, 675, 12, 139, "Text",ExpressionUUID->"db453ef0-9f00-4b6e-9f4a-687fbdf6cb9a"],
Cell[CellGroupData[{
Cell[54777, 1617, 2780, 87, 1340, "Input",ExpressionUUID->"863dbfce-2e46-4c29-904e-a73eb6f09e69"],
Cell[57560, 1706, 626, 16, 134, "Output",ExpressionUUID->"6285004d-b47c-44e5-9691-e273d907527f"],
Cell[58189, 1724, 626, 16, 134, "Output",ExpressionUUID->"92ee805b-efde-4b9f-94e5-866a43848c7f"],
Cell[58818, 1742, 788, 20, 134, "Output",ExpressionUUID->"cb0a6aa3-7a47-4f5d-a2ba-b7dffffcc487"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59655, 1768, 437, 7, 165, "Section",ExpressionUUID->"220dd669-50c8-4cb8-9089-7ec1424c60f1"],
Cell[60095, 1777, 590, 9, 84, "Text",ExpressionUUID->"6aa46707-f6a8-4fc5-9f76-2654afaf0058"],
Cell[CellGroupData[{
Cell[60710, 1790, 616, 18, 226, "Input",ExpressionUUID->"f16c455d-9674-4872-aea8-6cbe10b70c4f"],
Cell[CellGroupData[{
Cell[61351, 1812, 613, 18, 101, "Print",ExpressionUUID->"5bd9b9d8-64ba-4f51-bfdd-40d1bb0481c5"],
Cell[61967, 1832, 730, 21, 88, "Print",ExpressionUUID->"89ac2701-ceb1-47b7-a3bb-14b20a390bcf"],
Cell[62700, 1855, 1417, 37, 78, "Print",ExpressionUUID->"71e7015a-ba62-4a2c-91c0-c2eee12d082a"],
Cell[64120, 1894, 712, 20, 101, "Print",ExpressionUUID->"b79b2d38-17cc-4647-af2c-ff03cc46f577"],
Cell[64835, 1916, 1391, 36, 78, "Print",ExpressionUUID->"1e5a4af7-6a80-45db-9200-aee7049ac9b7"],
Cell[66229, 1954, 855, 33, 101, "Print",ExpressionUUID->"60150383-fcf9-46ea-aa4a-d6b24fa940c4"]
}, Open  ]]
}, Open  ]],
Cell[67111, 1991, 578, 9, 84, "Text",ExpressionUUID->"6ceb1243-7101-4a46-89e0-02725a11bb39"],
Cell[CellGroupData[{
Cell[67714, 2004, 477, 14, 175, "Input",ExpressionUUID->"97491c83-82e0-48ba-b102-3b02da99777b"],
Cell[CellGroupData[{
Cell[68216, 2022, 546, 16, 88, "Print",ExpressionUUID->"2d56075a-0acb-454d-b005-d748ac99b898"],
Cell[68765, 2040, 708, 20, 101, "Print",ExpressionUUID->"cbb7b5ca-4464-490d-8ea0-82a3609453e4"],
Cell[69476, 2062, 1308, 32, 78, "Print",ExpressionUUID->"1b521f80-7493-4ee9-ad70-941a246a5aad"],
Cell[70787, 2096, 575, 21, 101, "Print",ExpressionUUID->"cff186ac-8a1f-4ca4-ac36-40373cfb5759"]
}, Open  ]]
}, Open  ]],
Cell[71389, 2121, 595, 9, 84, "Text",ExpressionUUID->"8d412afa-a071-4621-a1e9-88b25cc38cae"],
Cell[CellGroupData[{
Cell[72009, 2134, 647, 18, 226, "Input",ExpressionUUID->"77b7e4b9-d66b-4cc8-9907-3b7dccd4942f"],
Cell[CellGroupData[{
Cell[72681, 2156, 610, 18, 78, "Print",ExpressionUUID->"08d8d3d9-8b67-4fef-be7f-d8591959ddf9"],
Cell[73294, 2176, 722, 21, 78, "Print",ExpressionUUID->"bd0171df-2c4e-413a-b1a9-571ddfac9664"],
Cell[74019, 2199, 1525, 41, 150, "Print",ExpressionUUID->"d7fc979a-0e65-4b06-b962-e4d51c602f28"],
Cell[75547, 2242, 651, 18, 88, "Print",ExpressionUUID->"6892ce6b-62fa-4b04-b1e0-0d8776ef3f16"],
Cell[76201, 2262, 1334, 32, 78, "Print",ExpressionUUID->"fc6deb98-3fb5-4a74-b70d-64170365207e"],
Cell[77538, 2296, 788, 27, 88, "Print",ExpressionUUID->"06070c23-25a4-4131-a9a8-b2c10e853857"]
}, Open  ]]
}, Open  ]],
Cell[78353, 2327, 587, 9, 84, "Text",ExpressionUUID->"21cb7d66-6f72-4fa8-8efc-4c8479dc3853"],
Cell[CellGroupData[{
Cell[78965, 2340, 593, 18, 226, "Input",ExpressionUUID->"5dcc8e9e-a00a-4ced-b248-59905b5b623c"],
Cell[CellGroupData[{
Cell[79583, 2362, 548, 16, 88, "Print",ExpressionUUID->"86eb1fc3-b33f-4648-b769-8ca166e74deb"],
Cell[80134, 2380, 727, 21, 101, "Print",ExpressionUUID->"166af5d2-9c59-47fc-9b3a-51fd5224e3f9"],
Cell[80864, 2403, 1308, 32, 78, "Print",ExpressionUUID->"aaf6f6a2-af1f-4f2d-9b4a-2aadc4d6b412"],
Cell[82175, 2437, 713, 21, 101, "Print",ExpressionUUID->"0379325c-e38e-4d92-92ae-705efdfb8cbb"],
Cell[82891, 2460, 1308, 32, 78, "Print",ExpressionUUID->"303006d1-b031-41b0-8053-17081f5dfacf"],
Cell[84202, 2494, 786, 30, 101, "Print",ExpressionUUID->"0b393304-efe8-4796-91bc-98216edf13f2"]
}, Open  ]]
}, Open  ]],
Cell[85015, 2528, 623, 9, 84, "Text",ExpressionUUID->"dc42a622-db81-41dc-84ee-b045f9eae8ea"],
Cell[CellGroupData[{
Cell[85663, 2541, 653, 18, 226, "Input",ExpressionUUID->"253acdbd-1d01-4e2b-9e11-d4e5d5f84c0b"],
Cell[CellGroupData[{
Cell[86341, 2563, 628, 18, 88, "Print",ExpressionUUID->"7c29ebc7-4271-49e8-a10a-080f7dbce5e9"],
Cell[86972, 2583, 640, 17, 88, "Print",ExpressionUUID->"efeafbd6-be8e-4beb-ba27-b044bc188fe8"],
Cell[87615, 2602, 1173, 24, 64, "Print",ExpressionUUID->"a531b6ab-3533-4663-8e3c-39d9a7297aac"],
Cell[88791, 2628, 990, 29, 146, "Print",ExpressionUUID->"4d8f60e7-e8d1-4d55-bc7c-e826094dbcfe"],
Cell[89784, 2659, 1660, 46, 152, "Print",ExpressionUUID->"b6dcc78c-8c24-4a44-ab74-38b13666dcd7"],
Cell[91447, 2707, 981, 36, 180, "Print",ExpressionUUID->"28b13147-077b-478a-b8fb-5f24def6af0b"]
}, Open  ]]
}, Open  ]],
Cell[92455, 2747, 571, 9, 84, "Text",ExpressionUUID->"94355cb7-2d27-478c-9aa3-547a5896fc6f"],
Cell[CellGroupData[{
Cell[93051, 2760, 2766, 87, 1050, "Input",ExpressionUUID->"9ed2d6df-c03a-42d0-97cf-06b64c3fb437"],
Cell[95820, 2849, 530, 18, 88, "Output",ExpressionUUID->"16061a6f-2673-45b2-a45b-c001ab0ac16a"]
}, Open  ]],
Cell[96365, 2870, 534, 8, 84, "Text",ExpressionUUID->"caea9d9b-0e8f-4fef-94b1-e26b1973cc95"],
Cell[CellGroupData[{
Cell[96924, 2882, 647, 18, 226, "Input",ExpressionUUID->"8983308a-cfa9-483d-8ef7-b43bf6efcfea"],
Cell[CellGroupData[{
Cell[97596, 2904, 627, 18, 101, "Print",ExpressionUUID->"116639c3-6a9d-454c-ac24-45c9051a4ebb"],
Cell[98226, 2924, 868, 25, 101, "Print",ExpressionUUID->"791f8961-9948-4a04-9c35-6db8b15e970f"],
Cell[99097, 2951, 1443, 37, 78, "Print",ExpressionUUID->"fe4b40ea-54a3-4056-91cb-37366b375a9e"],
Cell[100543, 2990, 968, 28, 88, "Print",ExpressionUUID->"d52284a1-efea-4166-a96b-c2b68cb55fb0"],
Cell[101514, 3020, 1548, 42, 152, "Print",ExpressionUUID->"812840bc-b797-45f4-bacd-67934be3d0d3"],
Cell[103065, 3064, 1127, 43, 188, "Print",ExpressionUUID->"2b631537-2e0e-4452-a708-a47b567a926f"]
}, Open  ]]
}, Open  ]],
Cell[104219, 3111, 665, 13, 193, "Text",ExpressionUUID->"f42bb7d0-693c-422a-974b-f985cedd5fd0"],
Cell[CellGroupData[{
Cell[104909, 3128, 2632, 90, 999, "Input",ExpressionUUID->"9e8dab9e-48c5-4762-8dcb-5f56a6cf09fd"],
Cell[107544, 3220, 369, 10, 83, "Output",ExpressionUUID->"a558419e-519f-4bc7-9b86-64d4ca930916"],
Cell[107916, 3232, 367, 10, 83, "Output",ExpressionUUID->"aad940f0-07c3-4313-bd5a-5570b5ca1b22"],
Cell[108286, 3244, 1077, 39, 223, "Output",ExpressionUUID->"b2267e1b-375b-4be9-a2a4-7295179f489a"]
}, Open  ]],
Cell[109378, 3286, 623, 9, 84, "Text",ExpressionUUID->"23390dc2-8f45-4255-bfa3-c4d62a0d7329"],
Cell[CellGroupData[{
Cell[110026, 3299, 677, 18, 226, "Input",ExpressionUUID->"1a6a5f11-9f22-4e8c-aacc-d9f59f63bf2e"],
Cell[CellGroupData[{
Cell[110728, 3321, 628, 18, 88, "Print",ExpressionUUID->"6f40a002-3e7f-4d37-8f50-e009e368c97c"],
Cell[111359, 3341, 1062, 31, 173, "Print",ExpressionUUID->"b63a01d2-90f6-437a-b5c9-d39d224db426"],
Cell[112424, 3374, 1467, 37, 152, "Print",ExpressionUUID->"40a33a80-d144-4370-a49e-6ba5f50853ba"],
Cell[113894, 3413, 1089, 33, 173, "Print",ExpressionUUID->"d70f5145-a651-444c-a47d-2c6f2cc80192"],
Cell[114986, 3448, 1660, 46, 151, "Print",ExpressionUUID->"82c378ac-19b1-4278-b783-be4c458abf2c"],
Cell[116649, 3496, 1336, 51, 242, "Print",ExpressionUUID->"ae677ae8-25ff-4076-8baa-997924cc95bb"]
}, Open  ]]
}, Open  ]],
Cell[118012, 3551, 606, 9, 84, "Text",ExpressionUUID->"26c5a170-b269-43e8-ba0f-876b09f67eee"],
Cell[CellGroupData[{
Cell[118643, 3564, 3591, 103, 1139, "Input",ExpressionUUID->"e8fdd967-62d7-448a-951e-0f5b96224f07"],
Cell[122237, 3669, 438, 13, 119, "Output",ExpressionUUID->"06dba05c-4ac7-435f-843a-69d0ba99b902"]
}, Open  ]]
}, Open  ]]
}
]
*)

